SELECT subsystem_id, subsystem,
       REPLACE(REVERSE(LEFT(REVERSE(subsystem_dll), CHARINDEX('\', REVERSE(subsystem_dll)))), '\', '') AS DLL,
	   REPLACE(REVERSE(LEFT(REVERSE(agent_exe), CHARINDEX('\', REVERSE(agent_exe)))), '\', '') AS AGENT
FROM   msdb.dbo.syssubsystems;

--> NOTA : Cette requte fonction de la version 2005  la version 2012. Pour la version 2014, utilisez :

SELECT subsystem_id, subsystem,
       subsystem_dll AS DLL,
	   REPLACE(REVERSE(LEFT(REVERSE(agent_exe), CHARINDEX('\', REVERSE(agent_exe)))), '\', '') AS AGENT
FROM   msdb.dbo.syssubsystems;

--> Pour une compatibilit globale :
WITH T AS 
(SELECT LEFT(CAST(SERVERPROPERTY('ProductVersion') AS VARCHAR(256)), CHARINDEX('.', CAST(SERVERPROPERTY('ProductVersion') AS VARCHAR(256))) -1) AS V)
SELECT subsystem_id, subsystem,
       CASE WHEN V < 12 
	           THEN REPLACE(REVERSE(LEFT(REVERSE(subsystem_dll), CHARINDEX('\', REVERSE(subsystem_dll)))), '\', '')
			   ELSE subsystem_dll 
	   END AS DLL,
	   REPLACE(REVERSE(LEFT(REVERSE(agent_exe), CHARINDEX('\', REVERSE(agent_exe)))), '\', '') AS AGENT
FROM   msdb.dbo.syssubsystems 
       CROSS JOIN T;
